DECLARE @BASE sysname,
        @RECOVERY sysname,
        @SQL NVARCHAR(max);

SET @BASE = 'MaBase';

-- On rcupre le mode de journalisation actuel
SELECT @RECOVERY = recovery_model_desc
FROM   sys.databases
WHERE  name = @BASE

-- On met la base en mono utilisateur
SET @SQL = 'ALTER DATABASE [' + @BASE +'] SET SINGLE_USER WITH ROLLBACK IMMEDIATE;'
EXEC (@SQL);

-- On place la base en mode de rcupration simple
SET @SQL = 'ALTER DATABASE [' + @BASE +'] SET RECOVERY SIMPLE;'
EXEC (@SQL);

SET @SQL = '';
-- On cre les ordres de purge des fichiers du journal
SELECT @SQL = @SQL + 'SHRINKFILE (' + CAST(file_id AS NVARCHAR(8)) +', 1);'
FROM   sys.master_files
WHERE  type_desc = 'LOG'
  AND  database_id = DB_ID(@BASE);

-- On excute la purge physique
EXEC (@SQL);

-- On replace la base dans son mode de journalisation initiale
SET @SQL = 'ALTER DATABASE [' + @BASE +'] SET RECOVERY ' + @RECOVERY + ';'
EXEC (@SQL); 

-- On met la base en multi utilisateur
SET @SQL = 'ALTER DATABASE [' + @BASE +'] SET MULTI_USER;'
EXEC (@SQL);

--> ATTENTION : plusieurs erreurs se sont glisses dans le script de la version imprime. 
--  1) La variable @RECOVERY n'est jamais assigne. 
--  2) dans la premire requte SELECT, la colonne "database_name" n'existe pas. C'est "name".
-- le prsent script rpare ces erreurs